<?php
/**
 * (C) CopyRight 2008 MagicToolBox - www.magictoolbox.com - support@magictoolbox.com
 */
 
 /*
     image/
        .....
            subdir/
                    ......
                        imageName.extension - base
                        imageName**.extension - additional
                        large/imageName**_LRG.extension - large images
                        medium/imageName**_MED.extension - medium images 
                        
      MagicToolbox use only large images. All thumbnails will be dinamicaly created 
 */
if (!defined('IS_ADMIN_FLAG')) die('Illegal Access');

// if Magic Thumb enabled
if (ZEN_MAGICTHUMB_STATUS == 'true') {
    
    //load module
    require_once(DIR_FS_CATALOG . DIR_WS_MODULES . 'magictoolbox/magictoolbox_addons.php');
    $mod = & magictoolboxLoadModule('MagicThumb');

    $images = array();
    
    // we can load additional images only if base image present
    if (!empty($products_image)) {
        $info = pathinfo($products_image);
        if(intval(phpversion()) < 5 || !isset($info["filename"])) {
            $info["filename"] = basename($info["basename"], ".".$info["extension"]);
        }
        if($info["dirname"] == '.') $info["dirname"] = '';
        if(!empty($info["dirname"])) $info["dirname"] .= '/';    
        $images = glob(DIR_FS_CATALOG . DIR_WS_IMAGES . $info["dirname"] . $info["filename"] . '*.' . $info["extension"]);    
    
        // found only original image
        if (count($images) == 1) $images = array();
    
        // sort images
        if (count($images) > 0) sort($images);
    }
    
    $list_box_contents = '';
    $title = '';
    $c = count($images);
    
    if ($c > 0) {
        $row = $col = 0;
        if ($c < IMAGES_AUTO_ADDED || IMAGES_AUTO_ADDED == 0 ) {
            $col_width = floor(100/$c);
        } else {
            $col_width = floor(100/IMAGES_AUTO_ADDED);
        }
    
        foreach($images as $k => $img) {
            $img = str_replace(DIR_FS_CATALOG . DIR_WS_IMAGES, '', $img);

            if($img == $products_image && $mod->params->checkValue('use-selectors', 'No')) continue;

            $info = pathinfo($img);
            if(intval(phpversion()) < 5 || !isset($info["filename"])) {
                $info["filename"] = basename($info["basename"], ".".$info["extension"]);
            }
            if($info["dirname"] == '.') $info["dirname"] = '';
            if(!empty($info["dirname"])) $info["dirname"] .= '/';
            $lrg = 'large/' . $info['dirname'] . $info['filename'] . IMAGE_SUFFIX_LARGE .'.'. $info['extension'];
            
            if(!file_exists(DIR_FS_CATALOG . DIR_WS_IMAGES . $lrg)) $lrg = $img;
            
            $img = DIR_WS_CATALOG . DIR_WS_IMAGES . $lrg;
            $medium = DIR_WS_CATALOG . magictoolboxGetThumb(DIR_WS_IMAGES . $lrg, $mod->params->getValue('thumb-size'), $mod->params->getValue('thumb-size-depends-on'), $mod->params->getValue('image-magick-path'));
            $thumb = DIR_WS_CATALOG . magictoolboxGetThumb(DIR_WS_IMAGES . $lrg, $mod->params->getValue('selector-size'), $mod->params->getValue('thumb-size-depends-on'), $mod->params->getValue('image-magick-path'));
            $id = 'MainImage';
            
            $link = $mod->subTemplate(compact("img","thumb","medium","id"));
        
            // List Box array generation:
            $list_box_contents[$row][$col] = array('params' => 'class="additionalImages centeredContent back"' . ' ' . 'style="width:' . $col_width . '%;"',
            'text' => "\n      " . $link);
            $col ++;
            if ($col > (IMAGES_AUTO_ADDED -1)) {
            $col = 0;
            $row ++;
            }
        }
    }
    $num_images = $c;
} else {
    //if disabled Magic Thumb then default template will be loaded
    require_once(dirname(dirname(__FILE__)) . "/" . basename(__FILE__));
}
?>
